<?php
/**
 * 作用：安装首页
 * 官网：Https://cms.nengyu.com
 * 作者：老头
 * ===========================================================================
 * 未经授权不允许对程序代码以任何形式任何目的的再发布。
 * ===========================================================================
**/

class Index extends InstallController
{
	function __construct()
	{
		parent::__construct();
	}

	function install()
	{
		if(is_file('data/install.lock') || IS_INSTALL)
		{
			exit('已经安装过，如需重新安装，请删除【data/install.lock】和【data/config.php】文件');
		}
		if(md5_file('index.php')=='')
		{
			exit('【md5_file】读写权限不足，请检查相关权限设置');
		}
	}
	
	function index()
	{
		self::install();
		$this->tp->show("index.php");
	}

	function check()
	{
		self::install();
		
		$result=true;
		$data=[];

		$key='Php版本';
	    $data[$key]['result']=PHP_VERSION;
	    $data[$key]['help']='';
		if(version_compare(PHP_VERSION,'5.4.0','<'))
		{
			$data[$key]['result']='<span>×</span>';
			$data[$key]['help']='当前版本：'.PHP_VERSION;
			$result=false;
		}

		$key='Gd库';
	    $data[$key]['result']='√';
	    $data[$key]['help']='';
		$gd=function_exists('gd_info')?gd_info():array();
		$gd=$gd['GD Version'];
		if(empty($gd))
		{
			$data[$key]['result']='<span>×</span>';
			$data[$key]['help']='请开启Gd库';
			$result=false;
		}

		$key='Pdo_Mysql';
	    $data[$key]['result']='√';
	    $data[$key]['help']='';
	    if(!extension_loaded('pdo_mysql'))
	    {
			$data[$key]['result']='<span>×</span>';
			$data[$key]['help']='请开启Pdo_Mysql';
			$result=false;
	    }

	    $key='Openssl';
	    $data[$key]['result']='√';
	    $data[$key]['help']='';
	    if(!(function_exists('openssl_decrypt') && function_exists('openssl_decrypt')))
	    {
			$data[$key]['result']='<span>×</span>';
			$data[$key]['help']='';
			$result=false;
	    }

	    $key='Curl';
	    $data[$key]['result']='√';
	    $data[$key]['help']='';
	    if(!function_exists('curl_init'))
	    {
			$data[$key]['result']='<span>×</span>';
			$data[$key]['help']='请开启Curl';
			$result=false;
	    }

	    $key='Scandir';
	    $data[$key]['result']='√';
	    $data[$key]['help']='';
	    if(!function_exists('scandir'))
	    {
			$data[$key]['result']='<span>×</span>';
			$data[$key]['help']='请开启Scandir';
			$result=false;
	    }

	    $file=[];
	    $error='权限不足或文件夹不存在';

	    $key='根目录';
	    $file[$key]['result']='√';
	    $file[$key]['help']='';
	    if(!is_really_writable('./'))
	    {
	    	$file[$key]['result']='<span>×</span>';
	    	$file[$key]['help']=$error;
			$result=false;
	    }

	    $key='附件【upfile】';
	    $file[$key]['result']='√';
	    $file[$key]['help']='';
	    if(!is_really_writable('upfile/'))
	    {
	    	$file[$key]['result']='<span>×</span>';
	    	$file[$key]['help']=$error;
			$result=false;
	    }

	    $key='日志【data/log】';
	    $file[$key]['result']='√';
	    $file[$key]['help']='';
	    if(!is_really_writable('data/log/'))
	    {
	    	$file[$key]['result']='<span>×</span>';
	    	$file[$key]['help']=$error;
			$result=false;
	    }

	    $key='插件【plug】';
	    $file[$key]['result']='√';
	    $file[$key]['help']='';
	    if(!is_really_writable('plug/'))
	    {
	    	$file[$key]['result']='<span>×</span>';
	    	$file[$key]['help']=$error;
			$result=false;
	    }

		$this->tp->add('data',$data);
		$this->tp->add('file',$file);
		$this->tp->add('result',$result);
		$this->tp->show("check.php");
	}

	function config()
	{
		if(IS_POST)
		{
			$t0=trim(F('t0'));
			$t1=trim(F('t1'));
			$t2=trim(F('t2'));
			$t3=trim(F('t3'));
			$t4=trim(F('t4'));
			$t5=trim(F('t5'));
			$t6=trim(F('t6'));
			$t7=trim(F('t7'));
			$data=[
				[$t0,'null','数据库地址不能为空'],
				[$t0,'char','数据库地址不能有特殊字符'],
				[$t1,'null','端口不能为空'],
				[$t1,'int','端口错误'],
				[$t2,'null','数据库名不能为空'],
				[$t2,'char','数据库名不能有特殊字符'],
				[$t3,'null','数据库账号不能为空'],
				[$t3,'char','数据库账号不能有特殊字符'],
				[$t4,'null','数据库密码不能为空'],
				[$t4,'char','数据库密码不能有特殊字符'],
				[$t5,'null','表前缀不能为空'],
				[$t5,'char','表前缀不能有特殊字符'],
				[$t6,'null','用户名不能为空'],
				[$t6,'username','用户名格式错误'],
				[$t7,'null','密码不能为空'],
				[$t7,'password','密码格式错误']
			];
			if(!check_pass($t7))
			{
				$data=array_merge($data,[[true,'other','密码须包含：字母、数字或字符']]);
			}
			$v=new cms_verify($data);
			if($v->result())
			{
				#尝试链接数据库
				$conn=new PDO('mysql:host='.$t0.';port='.$t1.';',$t3,$t4);
				$conn->exec("set names 'utf8mb4'");

				#创建数据库
				$conn->query("CREATE DATABASE IF NOT EXISTS `$t2` DEFAULT CHARACTER SET utf8mb4");

				#重新链接数据库
				$conn=new PDO('mysql:host='.$t0.';port='.$t1.';dbname='.$t2.'',$t3,$t4);
				$conn->exec("set names 'utf8mb4'");

				#读取Sql文件，写入数据库
				set_time_limit(0);

				$f=fopen('app/install/config/mysql.sql',"rb");
		        $table='';
		        while(!feof($f))
		        {
		            $line=fgets($f);
		            if(!preg_match('/;/',$line) || preg_match('/ENGINE=/',$line)) 
		            {
		                $table.=$line;
		                if (preg_match('/ENGINE=/',$table))
		                {
		                    $conn->query(self::deal_sql($table,$t5));
		                    $table='';
		                }
		                continue;
		            }
		            $conn->query(self::deal_sql($line,$t5));
		        }
		        fclose($f);

				#保存管理员信息
				$conn->query(self::deal_sql("insert into cms_admin (adminname,adminpass,penname,pid,logintimes,lastlogindate,lastloginip,islock,readonly) values ('".$t6."', '".md5(md5($t7))."', '创始人',0,0,".time().", '',1,0)",$t5));
				
				$rnd='cms_'.mt_rand(1000,9999);

				$file=file_get_contents("app/install/config/default.txt");
				$str=sprintf($file,$rnd,$t5,$t0,$t1,$t2,$t3,$t4);
				if(!savefile('data/config.php',$str))
				{
					$this->error('配置文件写入失败');
					return;
				}

				#创建安装锁
				if(!savefile('data/install.lock',time()))
				{
					$this->error('安装锁写入失败');
					return;
				}
				$this->success('安装成功');
			}
			else
			{
				$this->error($v->msg);
			}
		}
		else
		{
			self::install();
			$this->tp->show('config.php');
		}
	}

	function result()
	{
		$this->tp->show('result.php');
	}

	function deal_sql($a,$b)
	{
		$a=str_replace(", 'cms_",", 'tablename_",$a);
		$a=str_replace('cms_',$b,$a);
		$a=str_replace('%s',$b,$a);
		$a=str_replace('tablename_','cms_',$a);
		return $a;
	}

}